/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.util.locate.ammo;

import dev.toma.gunsrpg.api.common.IAmmoMaterial;
import dev.toma.gunsrpg.api.common.IAmmoProvider;
import dev.toma.gunsrpg.common.item.guns.ammo.AmmoType;
import dev.toma.gunsrpg.util.ModUtils;
import dev.toma.gunsrpg.util.locate.ILocatorPredicate;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public final class ItemLocator {
    public static final ItemLocator INSTANCE = new ItemLocator();

    public static ILocatorPredicate<ItemStack> filterByAmmoTypeAndMaterial(IAmmoProvider provider) {
        return ItemLocator.filterByAmmoTypeAndMaterial(provider.getAmmoType(), provider.getMaterial());
    }

    public static ILocatorPredicate<ItemStack> filterByAmmoTypeAndMaterial(@Nullable AmmoType type, @Nullable IAmmoMaterial material) {
        return stack -> {
            Item item = stack.func_77973_b();
            if (item instanceof IAmmoProvider) {
                IAmmoProvider provider = (IAmmoProvider)item;
                return !(type != null && provider.getAmmoType() != type || material != null && provider.getMaterial() != material);
            }
            return false;
        };
    }

    public static ILocatorPredicate<ItemStack> notDestroyedItem() {
        return stack -> !stack.func_190926_b() && stack.func_77952_i() < stack.func_77958_k();
    }

    public static ItemStack findFirst(IInventory inventory, ILocatorPredicate<ItemStack> filter) {
        return INSTANCE.findFirst(inventory, VanillaInventoryIterator.TYPE, filter);
    }

    public static boolean consume(IInventory inventory, ILocatorPredicate<ItemStack> filter, Consumer<InventoryContext> contextConsumer) {
        return INSTANCE.consumeFirst(inventory, VanillaInventoryIterator.TYPE, filter, contextConsumer, ItemStack.field_190927_a);
    }

    public static boolean contains(IInventory inventory, ILocatorPredicate<ItemStack> filter) {
        return INSTANCE.contains(inventory, VanillaInventoryIterator.TYPE, filter);
    }

    public static int sum(IInventory inventory, ILocatorPredicate<ItemStack> filter) {
        return INSTANCE.sum(inventory, VanillaInventoryIterator.TYPE, filter);
    }

    public <I, J> boolean consumeFirst(I inventory, InventoryIterator<I> iterator, ILocatorPredicate<ItemStack> filter, Consumer<InventoryContext> contextConsumer, ItemStack parent) {
        int slots = iterator.slots(inventory);
        for (int i = 0; i < slots; ++i) {
            boolean result;
            ItemStack stack = iterator.itemAt(inventory, i);
            if (stack.func_190926_b()) continue;
            if (filter.test(stack)) {
                InventoryContext context = new InventoryContext(stack, i, inventory, parent);
                contextConsumer.accept(context);
                ModUtils.saveInventoryFromContext(context);
                return true;
            }
            InventoryHolder<I> holder = this.getInventory(stack);
            if (holder == null || !(result = this.consumeFirst(((InventoryHolder)holder).inventory, ((InventoryHolder)holder).iterator, filter, contextConsumer, stack))) continue;
            return true;
        }
        return false;
    }

    public <I, J> ItemStack findFirst(I inventory, InventoryIterator<I> iterator, ILocatorPredicate<ItemStack> filter) {
        int slots = iterator.slots(inventory);
        for (int i = 0; i < slots; ++i) {
            ItemStack result;
            ItemStack stack = iterator.itemAt(inventory, i);
            if (stack.func_190926_b()) continue;
            if (filter.test(stack)) {
                return stack;
            }
            InventoryHolder<I> holder = this.getInventory(stack);
            if (holder == null || (result = this.findFirst(((InventoryHolder)holder).inventory, ((InventoryHolder)holder).iterator, filter)).func_190926_b()) continue;
            return result;
        }
        return ItemStack.field_190927_a;
    }

    public <I> boolean contains(I inventory, InventoryIterator<I> iterator, ILocatorPredicate<ItemStack> filter) {
        return !this.findFirst(inventory, iterator, filter).func_190926_b();
    }

    public <I, J> int sum(I inventory, InventoryIterator<I> iterator, ILocatorPredicate<ItemStack> filter) {
        int sum = 0;
        int slots = iterator.slots(inventory);
        for (int i = 0; i < slots; ++i) {
            InventoryHolder<I> holder;
            ItemStack stack = iterator.itemAt(inventory, i);
            if (stack.func_190926_b()) continue;
            if (filter.test(stack)) {
                sum += stack.func_190916_E();
            }
            if ((holder = this.getInventory(stack)) == null) continue;
            int nestedSum = this.sum(((InventoryHolder)holder).inventory, ((InventoryHolder)holder).iterator, filter);
            sum += nestedSum;
        }
        return sum;
    }

    private <I> InventoryHolder<I> getInventory(ItemStack stack) {
        IItemHandler handler;
        LazyOptional optional = stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
        if (optional.isPresent() && (handler = (IItemHandler)optional.orElseThrow(IllegalStateException::new)) instanceof IItemHandlerModifiable) {
            IItemHandlerModifiable modifiable = (IItemHandlerModifiable)handler;
            return InventoryProvider.forge(modifiable, stack);
        }
        if (stack.func_77973_b() instanceof InventoryProvider) {
            return ((InventoryProvider)stack.func_77973_b()).getInventoryHolder(stack);
        }
        return null;
    }

    private static final class ForgeInventoryIterator
    implements InventoryIterator<IItemHandlerModifiable> {
        private static final ForgeInventoryIterator TYPE = new ForgeInventoryIterator();

        private ForgeInventoryIterator() {
        }

        @Override
        public int slots(IItemHandlerModifiable inventory) {
            return inventory.getSlots();
        }

        @Override
        public ItemStack itemAt(IItemHandlerModifiable inventory, int index) {
            return inventory.getStackInSlot(index);
        }
    }

    private static final class VanillaInventoryIterator
    implements InventoryIterator<IInventory> {
        private static final VanillaInventoryIterator TYPE = new VanillaInventoryIterator();

        private VanillaInventoryIterator() {
        }

        @Override
        public int slots(IInventory inventory) {
            return inventory.func_70302_i_();
        }

        @Override
        public ItemStack itemAt(IInventory inventory, int index) {
            return inventory.func_70301_a(index);
        }
    }

    public static class InventoryHolder<I> {
        private final I inventory;
        private final InventoryIterator<I> iterator;
        private final ItemStack parent;

        private InventoryHolder(I inventory, InventoryIterator<I> iterator, ItemStack parent) {
            this.inventory = inventory;
            this.iterator = iterator;
            this.parent = parent;
        }
    }

    public static final class InventoryContext {
        private final ItemStack stack;
        private final int slotIndex;
        private final Object inventory;
        private final ItemStack parent;

        public InventoryContext(ItemStack stack, int slotIndex, Object inventory, ItemStack parent) {
            this.stack = stack;
            this.slotIndex = slotIndex;
            this.inventory = inventory;
            this.parent = parent;
        }

        public ItemStack getCurrectStack() {
            return this.stack;
        }

        public int getCurrentSlotIndex() {
            return this.slotIndex;
        }

        public Object getInventory() {
            return this.inventory;
        }

        public ItemStack getParent() {
            return this.parent;
        }
    }

    public static interface SaveInventoryProvider<I>
    extends InventoryProvider<I> {
        public void saveInventory(I var1, ItemStack var2);

        public void insertEditedItem(I var1, int var2, ItemStack var3);
    }

    @FunctionalInterface
    public static interface InventoryProvider<I> {
        public InventoryHolder<I> getInventoryHolder(ItemStack var1);

        public static <I> InventoryHolder<I> of(I inventory, InventoryIterator<I> iterator, ItemStack parent) {
            return new InventoryHolder(inventory, iterator, parent);
        }

        public static InventoryHolder<IInventory> vanilla(IInventory inventory, ItemStack parent) {
            return new InventoryHolder<IInventory>(inventory, VanillaInventoryIterator.TYPE, parent);
        }

        public static InventoryHolder<IItemHandlerModifiable> forge(IItemHandlerModifiable inventory, ItemStack parent) {
            return new InventoryHolder<IItemHandlerModifiable>(inventory, ForgeInventoryIterator.TYPE, parent);
        }
    }

    public static interface InventoryIterator<I> {
        public int slots(I var1);

        public ItemStack itemAt(I var1, int var2);
    }
}

